//
//  NSFontHelpers.h
//  GlyphsKit
//
//  Created by Georg Seifert on 27.09.18.
//  Copyright © 2018 Georg Seifert. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSFont (Helpers)

+ (CGFloat)fontSizeForHandleSize:(int)handleSize;

+ (NSFont *)legibleFontOfSize:(CGFloat)fontSize;

+ (NSFont *)boldLegibleFontOfSize:(CGFloat)fontSize;

+ (NSFont *)semiboldLegibleFontOfSize:(CGFloat)fontSize;

+ (NSFont *)lightLegibleFontOfSize:(CGFloat)fontSize;

+ (NSFont *)nameFontWithWidth:(CGFloat)width;

+ (NSFont *)monospaceFontOfSize:(CGFloat)fontSize;

+ (CGFontRef __nullable)CGFontWithFilePath:(NSString *)fontPath CF_RETURNS_RETAINED;

/// width is in percent 0.5-1
- (NSFont *)fontWithWidth:(CGFloat)width;

@end

NS_ASSUME_NONNULL_END
